
/* - MCAttachListener -
 * populate the fields and controls
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.MotorControlPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.AttachEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MCAttachListener implements AttachListener {

    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numMotorsTxt;
    private JTextField numInTxt;
    private JTextField numEncodersTxt;
    private JTextField numSensorsTxt;
    private JTextField tarVelTxt;
    private JTextField maxVelTxt;
    private JTextField accelTxt;
    private JTextField currentTxt;
    private JComboBox motorCmb;
    private JSlider maxVelScrl;
    private JSlider accelScrl;
    private JSlider brakeScrl;
    private JLabel jLabel19;
    private JCheckBox inputArray[];
    private JLabel jLabel10;
    private JTextField brakeTxt;
    private JLabel jLabel16;
    private JTextField supplyVoltageTxt;
    private JLabel jLabel18;
    private JCheckBox backEMFChk;
    private JTextField backEMFTxt;
    private JLabel jLabel17;
    private JLabel sensorLabel[];
    private JTextField sensorArray[];
    private JCheckBox ratiometricChk;
    private JLabel encoderLabel[];
    private JTextField encoderArray[];
    private JPanel inputPanel;
    private JPanel sensorPanel;
    private JPanel encoderPanel;

    /** Creates a new instance of MCAttachListener */
    public MCAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JTextField numMotorsTxt, JTextField numInTxt,
            JTextField numEncodersTxt, JTextField numSensorsTxt, JTextField tarVelTxt, JTextField maxVelTxt, JTextField accelTxt,
            JLabel jLabel10, JTextField currentTxt, JComboBox motorCmb, JSlider maxVelScrl,
            JSlider accelScrl, JSlider brakeScrl, JCheckBox inputArray[], JTextField brakeTxt, JLabel jLabel16, JTextField supplyVoltageTxt,
            JLabel jLabel18, JCheckBox backEMFChk, JTextField backEMFTxt, JLabel jLabel17, JLabel sensorLabel[], JTextField sensorArray[],
            JLabel encoderLabel[], JTextField encoderArray[], JLabel jLabel19, JPanel inputPanel, JPanel sensorPanel, JPanel encoderPanel,
            JCheckBox ratiometricChk) {

        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numMotorsTxt = numMotorsTxt;
        this.numInTxt = numInTxt;
        this.numEncodersTxt = numEncodersTxt;
        this.numSensorsTxt = numSensorsTxt;
        this.tarVelTxt = tarVelTxt;
        this.maxVelTxt = maxVelTxt;
        this.accelTxt = accelTxt;
        this.jLabel10 = jLabel10;
        this.currentTxt = currentTxt;
        this.motorCmb = motorCmb;
        this.maxVelScrl = maxVelScrl;
        this.accelScrl = accelScrl;
        this.brakeScrl = brakeScrl;
        this.jLabel19 = jLabel19;
        this.inputArray = inputArray;
        this.brakeTxt = brakeTxt;
        this.jLabel16 = jLabel16;
        this.supplyVoltageTxt = supplyVoltageTxt;
        this.jLabel18 = jLabel18;
        this.backEMFChk = backEMFChk;
        this.backEMFTxt = backEMFTxt;
        this.jLabel17 = jLabel17;
        this.sensorLabel = sensorLabel;
        this.sensorArray = sensorArray;
        this.ratiometricChk = ratiometricChk;
        this.encoderLabel = encoderLabel;
        this.encoderArray = encoderArray;
        this.inputPanel = inputPanel;
        this.sensorPanel = sensorPanel;
        this.encoderPanel = encoderPanel;
    }

    public void attached(AttachEvent ae) {
        try {
            MotorControlPhidget attached = (MotorControlPhidget) ae.getSource();
            attachedTxt.setText(Boolean.toString(attached.isAttached()));
            nameTxt.setText(attached.getDeviceName());
            serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            numMotorsTxt.setText(Integer.toString(attached.getMotorCount()));
            numInTxt.setText(Integer.toString(attached.getInputCount()));
            numEncodersTxt.setText(Integer.toString(attached.getEncoderCount()));
            numSensorsTxt.setText(Integer.toString(attached.getSensorCount()));

            int i;

            for (i = 0; i < attached.getMotorCount(); i++) {
                motorCmb.addItem(new Integer(i));
            }

            motorCmb.setSelectedIndex(0);
            motorCmb.setEnabled(true);

            inputPanel.setVisible(true);
            for (i = 0; i < attached.getInputCount(); i++) {
                inputArray[i].setVisible(true);
                inputArray[i].setEnabled(true);
            }
            accelScrl.setEnabled(true);
            maxVelScrl.setEnabled(true);

            if (attached.getDeviceID() == attached.PHIDID_MOTORCONTROL_LV_2MOTOR_4INPUT) {
                appFrame.setSize(357, 724);

                currentTxt.setEnabled(false);
            } else if (attached.getDeviceID() == attached.PHIDID_MOTORCONTROL_1MOTOR) {

                appFrame.setSize(357, 862);
                sensorPanel.setVisible(true);
                for (i = 0; i < attached.getSensorCount(); i++) {
                    sensorLabel[i].setVisible(true);
                    sensorArray[i].setVisible(true);
                    sensorArray[i].setEnabled(true);
                }
                ratiometricChk.setVisible(true);
                ratiometricChk.setEnabled(true);

                encoderPanel.setVisible(true);
                for (i = 0; i < attached.getEncoderCount(); i++) {
                    encoderLabel[i].setVisible(true);
                    encoderArray[i].setVisible(true);
                    encoderArray[i].setEnabled(true);
                    encoderArray[i].setText("0");
                }

                jLabel19.setEnabled(true);
                brakeScrl.setEnabled(true);
                brakeScrl.setMinimum(0);
                brakeScrl.setMaximum(100);
                brakeScrl.setValue(0);
                brakeTxt.setEnabled(true);
                jLabel16.setEnabled(true);
                brakeTxt.setText(Double.toString(attached.getBraking(0)));

                jLabel18.setEnabled(true);
                supplyVoltageTxt.setText(Double.toString(attached.getSupplyVoltage()));
                jLabel10.setEnabled(true);
                currentTxt.setEnabled(true);
                currentTxt.setText(Double.toString(attached.getCurrent(0)));

                backEMFChk.setEnabled(true);
                jLabel17.setEnabled(true);
                backEMFTxt.setEnabled(true);
                try {
                    backEMFChk.setSelected(attached.getBackEMFSensingState(0));
                    if (backEMFChk.isSelected()) {
                        backEMFTxt.setText(Double.toString(attached.getBackEMF(0)));
                    } else {
                        backEMFTxt.setText("");
                    }
                } catch (PhidgetException ex) {
                    backEMFTxt.setText("Unknown");
                }

            } else {
                appFrame.setSize(357, 724);
                jLabel10.setVisible(true);
                currentTxt.setVisible(true);
                currentTxt.setText(Double.toString(attached.getCurrent(0)));
            }

            accelScrl.setMinimum((int) Math.ceil(attached.getAccelerationMin(0)));
            accelScrl.setMaximum((int) attached.getAccelerationMax(0));
            accelScrl.setValue((int) Math.ceil(attached.getAccelerationMin(0)));

            accelTxt.setText(Double.toString(accelScrl.getValue()));


            maxVelScrl.setMaximum(100);
            maxVelScrl.setMinimum(-100);
            maxVelScrl.setValue(0);
            maxVelTxt.setText(Double.toString(attached.getVelocity(0)));

        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
}
